public class Game
{
  private Grid grid;
  private int userCol;
  private int msElapsed;
  private int timesGet;
  private int timesAvoid;
  
  public Game()
  {
    grid = new Grid(20, 5);
    userCol = 0;
    msElapsed = 0;
    timesGet = 5;
    timesAvoid = 0;
    updateTitle();
    grid.setImage(new Location(19, userCol), "My Ship.png");
  }
  
  public void play()
  {
    while (!isGameOver())
    {
      grid.pause(100);
      handleKeyPress();
      if (msElapsed % 300 == 0)
      {
        scrollDown();
        populateTopEdge();
      }
      updateTitle();
      msElapsed += 100;
    }
  }
  
  public void handleKeyPress()
  {
	  
      Location loc = new Location( 19,userCol );
      //grid.setImage(next, "My Ship.png");
      //String img = "My Ship.png";
      
      int key = grid.checkLastKeyPressed();
      if (key==37)
      {
          userCol = Math.max(userCol-1, 0);
      }
      if (key==39)
      {
          userCol = Math.min(userCol+1, grid.getNumCols()-1 );
      }
      
       Location next = new Location(19,userCol);
       handleCollision(next);
       
       grid.setImage( loc, null );
       
       grid.setImage(next, "My Ship.png");

       
  }
  
  public void handleKeyPressWRONG()
  {
      Location loc = new Location( userCol,0 );
      int key = grid.checkLastKeyPressed();
      if (key==38){
          userCol = Math.max(userCol-1, 0);
        }
      if (key==40){
          userCol = Math.min(userCol+1, grid.getNumRows()-1 );
        }
       Location next = new Location(userCol,0);
       handleCollision(next);
       
       grid.setImage( loc, null );
       
       grid.setImage(next, "user.gif");
       
  }
  
  public void populateTopEdge()
  {
      int row=1;
      int n = (int)(3*Math.random() );
      int bulletHellMode = 6;
      
      for (int i=0; i<n; i++){
          int c = (int)(grid.getNumCols()*Math.random() );
          Location loc = new Location (row-1, c);
          //if (Math.random()>.01){
          	//Location all = new Location (row-1, grid.getNumCols()-1);
              grid.setImage(loc, "Blaze_Powder.png");
          //else{
              //grid.setImage(loc, "get.gif");
          //}
          //}
      }
  }
  
  public void scrollLeft()
  {  //first col needs to be handled with user
      for (int r=0; r<grid.getNumRows();r++)
	  {
		  Location next = new Location(r,1);
		  if (r!=userCol){
			  grid.setImage(new Location(r,0), grid.getImage(next));
			  grid.setImage(next, null);
			  
		  }else{
		      //check for collision
		      handleCollision(next);
		  }
       }
       //now move left the others
      for (int c= 1 ; c<grid.getNumCols()-1; c++){
		      for (int r = 0 ; r< grid.getNumRows(); r++){
		         Location loc = new Location (r,c+1);
		         String img = grid.getImage(loc);
		         Location next = new Location (r, c);
		         grid.setImage(next, img);
		         
		      }
	  }
	  //clear out the last row
	  for (int r=0; r<grid.getNumRows(); r++)
	       grid.setImage(new Location(r, grid.getNumCols()-1), null);
}
  
  public void scrollDown()
  {  //bottom row needs to be handled with user
      for (int c=0; c<grid.getNumCols();c++)
	  {
		  Location next = new Location(grid.getNumRows()-1,c);
		  if (c!=userCol)
		  {
			  grid.setImage(new Location(grid.getNumRows()-1,c), grid.getImage(next));
			  grid.setImage(next, null);
			  
		  }else
		  {
		      //check for collision
		      handleCollision(next);
		  }
       }
       //now move down the others
      for (int r = grid.getNumRows()-2; r >=0; r--)
      {
		      for (int c = 0 ; c< grid.getNumCols(); c++){
		         Location loc = new Location (r,c);
		         String img = grid.getImage(loc);
		         Location next = new Location (r+1, c);
		         grid.setImage(next, img);
		         
		      }
	  }
	  //clear out the last row
	  for (int c=grid.getNumCols()-1; c>=0; c--)
	       grid.setImage(new Location(0, c), null);
}
     
  public void handleCollision(Location loc)
  {
      String img =grid.getImage(loc);
      if (img==null)
        return;
      //if (img.equals("get.gif")){
          //timesGet++;
      //}
      if (img.equals("Blaze_Powder.png")){
          timesAvoid++;
      }
      grid.setImage(loc, null);
  }
  
  public int getScore()
  {
    return 10*timesGet-5*timesAvoid;
  }
  
  public void updateTitle()
  {
    grid.setTitle("Game:  " + getScore()+ " Hits:"+ timesAvoid + " Points:"+timesGet);
  }
  
  public boolean isGameOver()
  {
    if(getScore() <= 0)
    	return true;
    return false;
  }
  
  public static void test()
  {
    Game game = new Game();
    game.play();
  }
  
  public static void main(String[] args)
  {
    test();
  }
}